moment_fun = function(p){
alpha = p[1]
beta = p[2]

f1 = 1/alpha + log(abs(beta)) - mean(log(abs(beta + x)))
f2 = alpha/beta - (alpha+1) * mean(1/(beta + x))
f = c(f1, f2)

J11 = -1/(alpha^2)
J12 = 1/beta- mean(1/(beta + x))
J21 = J12
J22 = - alpha/(beta^2) + (alpha + 1) * mean(1/(beta + x)^2)
J = matrix(c(J11, J12, J21, J22), nrow = 2, byrow = TRUE)

res = list(f = f, J = J)
}

## ep=1e-8, it_max=1000
## ep=1e-8, it_max=10000
## ep=1e-8, it_max=20
## ep=1e-5, it_max=20
Newtons = function (fun, y, ep=1e-8, it_max=1000){
index = 0; k = 1
while (k <= it_max){
	y1 = y; obj = fun(y);
	y  = y - solve(obj$J, obj$f);
	norm = sqrt((y-y1) %*% (y-y1))
	if (norm < ep){
		index = 1; break
	}
	k = k + 1
}
obj = fun(y);
res = list(root=y, it=k, index=index, FunVal=obj$f, norm=norm)
}

Moment_estimators_EX_EX2 = function(x){
A1 = mean(x)
A2 = mean(x^2) 

alpha_1 =  2*(A2 - A1^2) / (A2 - 2*A1^2)
beta_1 = (A1*A2) / (A2 - 2*A1^2)
res = c(alpha_1, beta_1)
}

Pearson_chisquare_test = function(nn, p, r){
  ## nn - frequencies
  ## p  - theoretical probabilities
  ## r  - number of unknown parameters
  
  n = sum(nn)
  m = length(nn)
  K = sum((nn - n * p)^2 / (n * p))
  df = m - 1 - r
  P_value = 1 - pchisq(K, df = df)
  
  res = data.frame(Chisquare = K, P_value = P_value, df = df, m = m, n = n)
}

Marginal_density = function(x){
  res = alpha * Beta^alpha / (Beta + x)^(alpha + 1)
}

Marginal_density_alpha_beta = function(x, alpha, beta){
  res = alpha * beta^alpha / (beta + x)^(alpha + 1)
}

p_Exp_IG_alpha_Beta = function(x, alpha, Beta){
  alpha <<- alpha
  Beta <<- Beta
  
  L_x = length(x)
  I_value = I_abs_error = numeric(L_x)
  for (i in 1:L_x){
    I_i = integrate(f = Marginal_density, lower = 0, upper = x[i])
    I_value[i] = I_i$value
    I_abs_error[i] = I_i$abs.error
  }

  # res = list(I_value = I_value, I_abs_error = I_abs_error)
  res = I_value
}

Generate_Matrix_Latex = function(A){
  m = nrow(A)
  n = ncol(A)
  
  C = rep("c", n, sep=""); C
  temp = "[c]{"
  for (i in 1:n){
    temp = paste(temp, C[i], sep="")
  }
  temp = paste(temp, "}", sep="")
  
  B = matrix("0", nrow = m, ncol = 2*n); B
  for (i in 1:m){
    for (j in 1:n){
      B[i, 2*j-1] = A[i, j]
      B[i, 2*j]   = "&"
    }
  }
  B[, 2*n] = "\\\\"
  B[m, 2*n] = ""
  B
  
  One = "\\begin{tabular}"
  Two = temp
  Three = B
  Four = "\\end{tabular}"
  
  cat(One, "\n", Two, "\n"); for (i in 1:m) cat(B[i, ], "\n");  cat(Four, "\n")
}

######################
Compute_Proportions_vector_pmin = function(v1, v2, v3){
  min_v = pmin(v1, v2, v3)
  Proportions = numeric(3)
  Proportions[1] = mean(v1 == min_v) 
  Proportions[2] = mean(v2 == min_v) 
  # Proportions[3] = mean(v3 == min_v) 
  Proportions[3] = 1 - Proportions[1] - Proportions[2] # to avoid several minimums
  
  res = Proportions
}

Compute_Proportions_vector_pmax = function(v1, v2, v3){
  max_v = pmax(v1, v2, v3)
  Proportions = numeric(3)
  Proportions[1] = mean(v1 == max_v) 
  Proportions[2] = mean(v2 == max_v) 
  # Proportions[3] = mean(v3 == max_v) 
  Proportions[3] = 1 - Proportions[1] - Proportions[2] # to avoid several maximums
  
  res = Proportions
}

######################

Compute_Estimators_PESLs = function(x, alpha, beta){
alpha1 = alpha + 1
beta1 = beta + x

delta_s = beta1 / alpha1
delta_2 = beta1 / (alpha1 - 1)
PESL_s = log(alpha1) - digamma(alpha1)
PESL_2 = 1 / (alpha1 - 1) + log(alpha1 - 1) - digamma(alpha1)

res = data.frame(delta_s, delta_2, PESL_s, PESL_2)
}

Compute_PostDist_Estimators_PESLs = function(x_np1, alpha, beta){
alpha1 = alpha + 1
beta1 = beta + x_np1

PostDist_theta = 1 / rgamma(n = 1e4, shape = alpha1, scale = 1 / beta1)
delta_s = beta1 / alpha1
delta_2 = beta1 / (alpha1 - 1)
PESL_s = log(alpha1) - digamma(alpha1)
PESL_2 = 1 / (alpha1 - 1) + log(alpha1 - 1) - digamma(alpha1)

res = list(PostDist_theta = PostDist_theta, delta_s = delta_s, delta_2 = delta_2, PESL_s = PESL_s, PESL_2 = PESL_2)
}

plot_estimator = function(delta_s, delta_2, parameter, para_name, xlab, legend_pos, sub){
dev.new()
col = c("blue", "red")
lty = 1:2
xlim = range(parameter)
ylim = range(delta_s, delta_2)
#ylim=c(0:1)
plot(parameter, delta_s, type = "n", xlim = xlim, ylim = ylim, xlab = xlab, ylab = "Estimator", sub = sub)
lines(parameter, delta_s, lty = lty[1], col = col[1], lwd = 4)
lines(parameter, delta_2, lty = lty[2], col = col[2], lwd = 4)
leg.txt = c("delta_s", "delta_2")
legend(x = legend_pos, legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/Exp-IG_Estimator_", para_name, "_change", sep = ""), type = c("pdf"))
savePlot(filename = paste("figure/Exp-IG_Estimator_", para_name, "_change", sep = ""), type = c("jpg"))
}

plot_PESL = function(PESL_s, PESL_2, parameter, para_name, xlab, legend_pos, sub){
dev.new()
col = c("blue", "red")
lty = 1:2
xlim = range(parameter)
ylim = range(PESL_s, PESL_2)
plot(parameter, PESL_s, type = "n", xlim = xlim, ylim = ylim, xlab = xlab, ylab = "PESL", sub = sub)
lines(parameter, PESL_s, lty = lty[1], col = col[1], lwd = 4)
lines(parameter, PESL_2, lty = lty[2], col = col[2], lwd = 4)
leg.txt = c("PESL_s", "PESL_2")
legend(x = legend_pos, legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/Exp-IG_PESL_", para_name, "_change", sep = ""), type = c("pdf"))
savePlot(filename = paste("figure/Exp-IG_PESL_", para_name, "_change", sep = ""), type = c("jpg"))
}

Compute_Proportions_2vectors_pmin = function(v1, v2){
min_v = pmin(v1, v2)
Proportions = numeric(2)
Proportions[1] = mean(v1 == min_v) 
# Proportions[2] = mean(v2 == min_v) 
Proportions[2] = 1 - Proportions[1] # to avoid several minimums

res = Proportions
}

plot_delta_PESL = function(x, y_oracle, y_MLE, y_moment, ylab, leg_pos, fig_name, sub){
dev.new()
col = c("red", "purple", "blue")
lty = 1:3
xlim = range(x)
ylim = range(y_oracle, y_MLE, y_moment)
plot(x,  y_oracle, type = "n", xlim = xlim, ylim = ylim, xlab = expression(m), ylab = ylab, sub = sub)
lines(x, y_oracle,  lty = lty[1], col = col[1], lwd = 4)
lines(x, y_MLE,     lty = lty[2], col = col[2], lwd = 4)
lines(x, y_moment,  lty = lty[3], col = col[3], lwd = 4)
# title(Title)
leg.txt = c("oracle", "mle", "moment")
legend(x = leg_pos, legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/", fig_name, sep=""), type = c("pdf"))
savePlot(filename = paste("figure/", fig_name, sep=""), type = c("jpg"))
}

Compute_E_V_of_X = function(alpha, beta){
E_X = beta / (alpha - 1)
V_X = alpha * beta^2 / ((alpha - 1)^2 * (alpha - 2))
res = data.frame(E_X, V_X)
}



